<?xml version="1.0" encoding="UTF-8"?>
<!DOCTYPE xslsheet [
<!ENTITY nbsp	"&#160;">
<!ENTITY bull     "&#8226;">
<!ENTITY szlig     "&#223;">
]>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:fo="http://www.w3.org/1999/XSL/Format">
	<xsl:output method="html" encoding="UTF-8"/>
	
<xsl:variable name="translation-context">EventSearch</xsl:variable>
<xsl:include href="include.xsl"/>

<xsl:template match="/print">

<html>
<head>
	<meta http-equiv="content-type" content="text/html; charset=UTF-8"/>
	<style>
	BODY, TD {
	  	font-family: "VAGRounded LT Thin";
  		font-size: 10pt;
  		color: #002080;
  		text-align:center;
	}
  </style>
</head>
			<body>
				<center>
					<table width="100%" cellpadding="0" cellspacing="0">
						<tr>
							<td align="left">
								<xsl:call-template name="tr"><xsl:with-param name="source">MxControlCenter &nbsp;&bull;&nbsp; Video Search</xsl:with-param></xsl:call-template>
							</td>
							<td align="right" style="color:black">
								<xsl:call-template name="tr"><xsl:with-param name="source">Camera IP Address</xsl:with-param></xsl:call-template>:									
								<xsl:value-of select="data/ip"/>
								<br/>
								<xsl:call-template name="tr"><xsl:with-param name="source">Recording Time</xsl:with-param></xsl:call-template>:								
								<xsl:value-of select="data/recordingtime"/>
								&nbsp;&bull;&nbsp;
								<xsl:call-template name="tr"><xsl:with-param name="source">Print Time</xsl:with-param></xsl:call-template>:
								<xsl:value-of select="data/printtime"/>
							
							</td>
						</tr>
					</table>	
					<table width="100%" cellpadding="0" cellspacing="0">
						<tr>
							<td align="center" colspan="2">
								<img height="1">
									<xsl:attribute name="src">
										<xsl:value-of select="template-path"/>
										<xsl:text>blue1.gif</xsl:text>
									</xsl:attribute>
									<xsl:attribute name="width">
										<xsl:value-of select="paper/content/@width"/>
									</xsl:attribute>
								</img>
							</td>
						</tr>
					</table>
					<table width="100%" cellpadding="0" cellspacing="0">
						<tr>						
							<td align="left">
								<xsl:call-template name="tr">
								<xsl:with-param name="source">MOBOTIX AG &nbsp;&bull;&nbsp; Security-Vision-Systems </xsl:with-param>
								</xsl:call-template>
							</td>						
							<td align="right" style="color:black">
								<xsl:call-template name="tr">
								<xsl:with-param name="source">www.mobotix.com</xsl:with-param>							
								</xsl:call-template>
							</td>
						</tr>
					</table>
				</center>
			</body>
		</html>
	</xsl:template>
</xsl:stylesheet>
